/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.util;

import com.eeeab.eeeabsmobs.sever.entity.impl.effect.EntityFallingBlock;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;

public class ModEntityUtils {
    private ModEntityUtils() {
    }

    public static boolean isProjectileSource(DamageSource source) {
        Entity entity = source.m_7640_();
        return entity instanceof Projectile || source.m_19360_();
    }

    public static Vec3 findPounceTargetPoint(Entity attacker, Entity target, double overshoot) {
        double vx = target.m_20185_() - attacker.m_20185_();
        double vz = target.m_20189_() - attacker.m_20189_();
        float angle = (float)Math.atan2(vz, vx);
        double distance = Mth.m_14116_((float)((float)(vx * vx + vz * vz)));
        double dx = (double)Mth.m_14089_((float)angle) * (distance + overshoot);
        double dz = (double)Mth.m_14031_((float)angle) * (distance + overshoot);
        return new Vec3(attacker.m_20185_() + dx, target.m_20186_(), attacker.m_20189_() + dz);
    }

    public static void spawnFallingBlockByPos(ServerLevel level, BlockPos pos, float fallingFactor) {
        Random random = new Random();
        BlockPos abovePos = new BlockPos((Vec3i)pos).m_7494_();
        BlockState block = level.m_8055_(pos);
        BlockState blockAbove = level.m_8055_(abovePos);
        fallingFactor = random.nextBoolean() ? (float)((double)fallingFactor + (0.4 + random.nextGaussian() * 0.2)) : (float)((double)fallingFactor - Mth.m_14008_((double)(0.2 + random.nextGaussian() * 0.2), (double)0.2, (double)((double)fallingFactor - 0.1)));
        if (block.m_60767_() != Material.f_76296_ && block.m_60796_((BlockGetter)level, pos) && !block.m_155947_() && !blockAbove.m_60767_().m_76334_()) {
            EntityFallingBlock fallingBlock = new EntityFallingBlock((Level)level, block, (float)(0.32 + (double)fallingFactor * 0.2));
            fallingBlock.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5);
            level.m_7967_((Entity)fallingBlock);
        }
    }

    public static void spawnFallingBlockByPos(ServerLevel level, BlockPos pos) {
        RandomSource random = RandomSource.m_216327_();
        BlockPos abovePos = new BlockPos((Vec3i)pos).m_7494_();
        BlockState block = level.m_8055_(pos);
        BlockState blockAbove = level.m_8055_(abovePos);
        if (block.m_60767_() != Material.f_76296_ && block.m_60796_((BlockGetter)level, pos) && !block.m_155947_() && !blockAbove.m_60767_().m_76334_()) {
            EntityFallingBlock fallingBlock = new EntityFallingBlock((Level)level, (double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5, block, 10);
            fallingBlock.m_5997_(0.0, 0.2 + random.m_188583_() * 0.2, 0.0);
            level.m_7967_((Entity)fallingBlock);
        }
    }

    public static Vec3 checkSummonEntityPoint(LivingEntity summoner, double pX, double pZ, double pMinY, double pMaxY) {
        BlockPos blockpos = new BlockPos(pX, pMaxY, pZ);
        boolean flag = false;
        double d0 = 0.0;
        ServerLevel level = (ServerLevel)summoner.f_19853_;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = level.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)level, blockpos1, Direction.UP)) continue;
            if (!level.m_46859_(blockpos) && !(voxelshape = (blockstate1 = level.m_8055_(blockpos)).m_60812_((BlockGetter)level, blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)pMinY) - 1);
        if (flag) {
            return new Vec3(pX, (double)blockpos.m_123342_() + d0, pZ);
        }
        return new Vec3(summoner.m_20185_(), summoner.m_20186_(), summoner.m_20189_());
    }

    public static boolean checkTargetComingCloser(LivingEntity entity, LivingEntity target) {
        Vec3 betweenEntitiesVec = entity.m_20182_().m_82546_(target.m_20182_());
        return target.m_20184_().m_82526_(betweenEntitiesVec) > 0.0 && target.m_20184_().m_82556_() > 0.015;
    }

    public static boolean canDestroyBlock(Level world, BlockPos pos, Entity entity, float maxBlockHardness) {
        return ModEntityUtils.canDestroyBlock(world, pos, world.m_8055_(pos), maxBlockHardness, entity);
    }

    public static boolean canDestroyBlock(Level world, BlockPos pos, Entity entity) {
        return ModEntityUtils.canDestroyBlock(world, pos, world.m_8055_(pos), 50.0f, entity);
    }

    public static boolean canDestroyBlock(Level world, BlockPos pos, BlockState state, float maxBlockHardness, Entity entity) {
        float hardness = state.m_60800_((BlockGetter)world, pos);
        return hardness >= 0.0f && hardness <= maxBlockHardness && !state.m_60795_() && state.m_60734_().canEntityDestroy(state, (BlockGetter)world, pos, entity) && (!(entity instanceof LivingEntity) || ForgeEventFactory.onEntityDestroyBlock((LivingEntity)((LivingEntity)entity), (BlockPos)pos, (BlockState)state));
    }

    public static boolean canMobDestroy(Entity entity) {
        return ForgeEventFactory.getMobGriefingEvent((Level)entity.f_19853_, (Entity)entity);
    }

    public static void forceKnockBack(LivingEntity attackTarget, float strength, double ratioX, double ratioZ, double knockBackResistanceReduction, boolean canceledEventKnockBack) {
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)attackTarget, (float)strength, (double)ratioX, (double)ratioZ);
        if (canceledEventKnockBack && event.isCanceled()) {
            return;
        }
        strength = event.getStrength();
        ratioX = event.getRatioX();
        ratioZ = event.getRatioZ();
        if (!((strength = (float)((double)strength * (1.0 - attackTarget.m_21133_(Attributes.f_22278_) * knockBackResistanceReduction))) <= 0.0f)) {
            attackTarget.f_19812_ = true;
            Vec3 vector3d = attackTarget.m_20184_();
            Vec3 vector3d1 = new Vec3(ratioX, 0.0, ratioZ).m_82541_().m_82490_((double)strength);
            attackTarget.m_20334_(vector3d.f_82479_ / 2.0 - vector3d1.f_82479_, attackTarget.m_20096_() ? Math.min(0.4, vector3d.f_82480_ / 2.0 + (double)strength) : vector3d.f_82480_, vector3d.f_82481_ / 2.0 - vector3d1.f_82481_);
        }
    }

    public static float getTargetRelativeAngle(LivingEntity entity, LivingEntity target) {
        float entityHitAngle = (float)((Math.atan2(target.m_20189_() - entity.m_20189_(), target.m_20185_() - entity.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
        float entityAttackingAngle = entity.f_20883_ % 360.0f;
        if (entityHitAngle < 0.0f) {
            entityHitAngle += 360.0f;
        }
        if (entityAttackingAngle < 0.0f) {
            entityAttackingAngle += 360.0f;
        }
        return entityHitAngle - entityAttackingAngle;
    }

    public static float getTargetRelativeAngle(LivingEntity entity, Vec3 position) {
        float entityHitAngle = (float)((Math.atan2(position.m_7094_() - entity.m_20189_(), position.m_7096_() - entity.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
        float entityAttackingAngle = entity.f_20883_ % 360.0f;
        if (entityHitAngle < 0.0f) {
            entityHitAngle += 360.0f;
        }
        if (entityAttackingAngle < 0.0f) {
            entityAttackingAngle += 360.0f;
        }
        return entityHitAngle - entityAttackingAngle;
    }
}

